  document.addEventListener("DOMContentLoaded", function () {
    // === ローディングアニメーション関連 ===
    const preloader = document.getElementById("preloader");
    const loadingText = document.getElementById("loading-text");
    let progress = 0;

    const loadingInterval = setInterval(() => {
      progress += 1;
      loadingText.textContent = `Loading... ${progress}%`;
      if (progress >= 100) {
        clearInterval(loadingInterval);
        preloader.classList.add("loaded");
        setTimeout(() => {
          preloader.style.display = "none";
        }, 1200);
      }
    }, 20);

    // === フェードインアニメーション ===
    const observer = new IntersectionObserver(entries => {
      entries.forEach(entry => {
        if (entry.isIntersecting) {
          entry.target.classList.add("visible");
        }
      });
    }, { threshold: 0.1 });

    document.querySelectorAll(".fade-in").forEach(el => observer.observe(el));

    // === メニュー表示トグル（circle-scroll） ===
    const toggleBtn = document.getElementById("menuToggleBtn");
    const menu = document.getElementById("floatingMenu");

    toggleBtn.addEventListener("click", function () {
      menu.style.display = (menu.style.display === "flex") ? "none" : "flex";
    });
  });

 
    function openModal(img) {
        const modal = document.getElementById('imageModal');
        const modalImg = document.getElementById('modalImage');
        modal.style.display = 'flex';
        modalImg.src = img.src;
        modalImg.alt = img.alt;
    }

    function closeModal() {
        document.getElementById('imageModal').style.display = 'none';
    }
